<?php
$originalFile = 'https://cloudkings.vip/originales/listas/cinema.m3u'; // o una URL remota

$content = file_get_contents($originalFile);
$lines = explode("\n", $content);

// Detectar automáticamente el dominio
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];
$path = dirname($_SERVER['PHP_SELF']);
$proxyDomain = $protocol . $domain . rtrim($path, '/') . '/stream.php?u=';

header("Content-Type: application/x-mpegURL");
echo "#EXTM3U\n";

for ($i = 0; $i < count($lines); $i++) {
    $line = trim($lines[$i]);
    if (strpos($line, "#EXTINF") === 0) {
        echo $line . "\n";
        $realUrl = trim($lines[$i + 1] ?? '');
        if (filter_var($realUrl, FILTER_VALIDATE_URL)) {
            $encoded = urlencode(base64_encode($realUrl));
            echo $proxyDomain . $encoded . "\n";
        }
    }
}
?>
